# -*- coding: utf-8 -*-
"""r07.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/187uoAkUtgZfFdUMOZbP1IpGTJt4LOj85
"""

import numpy as np
import matplotlib.pyplot as plt

import matplotlib.animation as animation
from matplotlib import rc
rc('animation', html='jshtml')

from skimage import io,color
from scipy.signal import convolve2d

import pandas as pd

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Macierze kowariancji"""

# informacje o danych
#https://archive.ics.uci.edu/ml/datasets/Communities+and+Crime

# surowe dane
#https://archive.ics.uci.edu/ml/machine-learning-databases/communities/communities.data

# odwołanie do zbioru (więcej informacji na powyższej stronie):
# Redmond, M. A. and A. Baveja: A Data-Driven Software Tool for Enabling Cooperative Information Sharing Among Police Departments. European Journal of Operational Research 141 (2002) 660-678.

# wczytuję dane do ramki danych Pandas
url  = 'https://archive.ics.uci.edu/ml/machine-learning-databases/communities/communities.data'
data = pd.read_csv(url,sep=',',header=None)

data.columns = [ 'state', 'county', 'community', 'communityname', 'fold', 'population', 'householdsize', 'racepctblack', 'racePctWhite',
'racePctAsian', 'racePctHisp', 'agePct12t21', 'agePct12t29', 'agePct16t24', 'agePct65up', 'numbUrban', 'pctUrban', 'medIncome', 'pctWWage',
'pctWFarmSelf', 'pctWInvInc', 'pctWSocSec', 'pctWPubAsst', 'pctWRetire', 'medFamInc', 'perCapInc', 'whitePerCap', 'blackPerCap', 'indianPerCap',
'AsianPerCap', 'OtherPerCap', 'HispPerCap', 'NumUnderPov', 'PctPopUnderPov', 'PctLess9thGrade', 'PctNotHSGrad', 'PctBSorMore', 'PctUnemployed', 'PctEmploy',
'PctEmplManu', 'PctEmplProfServ', 'PctOccupManu', 'PctOccupMgmtProf', 'MalePctDivorce', 'MalePctNevMarr', 'FemalePctDiv', 'TotalPctDiv', 'PersPerFam', 'PctFam2Par',
'PctKids2Par', 'PctYoungKids2Par', 'PctTeen2Par', 'PctWorkMomYoungKids', 'PctWorkMom', 'NumIlleg', 'PctIlleg', 'NumImmig', 'PctImmigRecent', 'PctImmigRec5',
'PctImmigRec8', 'PctImmigRec10', 'PctRecentImmig', 'PctRecImmig5', 'PctRecImmig8', 'PctRecImmig10', 'PctSpeakEnglOnly', 'PctNotSpeakEnglWell', 'PctLargHouseFam', 'PctLargHouseOccup',
'PersPerOccupHous', 'PersPerOwnOccHous', 'PersPerRentOccHous', 'PctPersOwnOccup', 'PctPersDenseHous', 'PctHousLess3BR', 'MedNumBR', 'HousVacant', 'PctHousOccup', 'PctHousOwnOcc',
'PctVacantBoarded', 'PctVacMore6Mos', 'MedYrHousBuilt', 'PctHousNoPhone', 'PctWOFullPlumb', 'OwnOccLowQuart', 'OwnOccMedVal', 'OwnOccHiQuart', 'RentLowQ', 'RentMedian',
'RentHighQ', 'MedRent', 'MedRentPctHousInc', 'MedOwnCostPctInc', 'MedOwnCostPctIncNoMtg', 'NumInShelters', 'NumStreet', 'PctForeignBorn', 'PctBornSameState', 'PctSameHouse85',
'PctSameCity85', 'PctSameState85', 'LemasSwornFT', 'LemasSwFTPerPop', 'LemasSwFTFieldOps', 'LemasSwFTFieldPerPop', 'LemasTotalReq', 'LemasTotReqPerPop', 'PolicReqPerOffic', 'PolicPerPop',
'RacialMatchCommPol', 'PctPolicWhite', 'PctPolicBlack', 'PctPolicHisp', 'PctPolicAsian', 'PctPolicMinor', 'OfficAssgnDrugUnits', 'NumKindsDrugsSeiz', 'PolicAveOTWorked', 'LandArea',
'PopDens', 'PctUsePubTrans', 'PolicCars', 'PolicOperBudg', 'LemasPctPolicOnPatr', 'LemasGangUnitDeploy', 'LemasPctOfficDrugUn', 'PolicBudgPerPop', 'ViolentCrimesPerPop',
 ]

data

# interesują mnie jedynie dane liczbowe
numberDataset = data._get_numeric_data()

# pozbywam się jeszcze kilku kolumn i zapisuję całość w tablicy NumPy
dataMat = numberDataset.drop(['state','fold'],axis=1).values
dataMat

datamean = np.mean(dataMat,axis=0) # wektor średnich z cech
dataMatM = dataMat - datamean # wyśrodkowywanie za pomocą broadcastingu

print(np.mean(dataMatM[:,0]))


covMat = dataMatM.T @ dataMatM  # mnożenie macierzy danych przez jej transpozycję
covMat /= (dataMatM.shape[0]-1) # dzielenie przez N-1

clim = np.max(np.abs(covMat)) * .2

plt.figure(figsize=(6,6))
plt.imshow(covMat,vmin=-clim,vmax=clim,cmap='gray')
plt.colorbar()
plt.title('Macierz kowariancji danych')
plt.savefig('rys7.1.png',dpi=300)
plt.show()



"""# Macierze transformacji"""

th = np.pi/5

T = np.array([
              [ np.cos(th),np.sin(th)],
              [-np.sin(th),np.cos(th)]
            ])


x = np.linspace(-1,1,20)
origPoints = np.vstack( (np.zeros(x.shape),x) )


transformedPoints = T @ origPoints


plt.figure(figsize=(6,6))
plt.plot(origPoints[0,:],origPoints[1,:],'ko',label='Przed obrotem')
plt.plot(transformedPoints[0,:],transformedPoints[1,:],'s',color=[.7,.7,.7],label='Po obrocie')

plt.axis('square')
plt.xlim([-1.2,1.2])
plt.ylim([-1.2,1.2])
plt.legend()
plt.title(f'Obrót o {np.rad2deg(th):.0f} stopni')
plt.savefig('rys7.2.png',dpi=300)
plt.show()



"""# Animacja"""

def aframe(ph):

  # tworzę macierz transformacji i stosuję ją na zbiorze punktów
  T = np.array([
                 [  1, 1-ph ],
                 [  0, 1    ]
                ])

  P = T@points

  # aktualizuję lokalizacje poszczególnych kropek
  plth.set_xdata(P[0,:])
  plth.set_ydata(P[1,:])

  return plth


theta  = np.linspace(0,2*np.pi,100)
points = np.vstack((np.sin(theta),np.cos(theta)))


fig,ax = plt.subplots(1,figsize=(12,6))
plth,  = ax.plot(np.cos(x),np.sin(x),'ko')
ax.set_aspect('equal')
ax.set_xlim([-2,2])
ax.set_ylim([-2,2])

phi = np.linspace(-1,1-1/40,40)**2

animation.FuncAnimation(fig, aframe, phi, interval=100, repeat=True)



"""# Konwolucja"""

imgN  = 20
image = np.random.randn(imgN,imgN)

kernelN = 7
Y,X     = np.meshgrid(np.linspace(-3,3,kernelN),np.linspace(-3,3,kernelN))
kernel  = np.exp( -(X**2+Y**2)/7 )
kernel  = kernel / np.sum(kernel)

halfKr = kernelN//2
convoutput = np.zeros((imgN+kernelN-1,imgN+kernelN-1))

imagePad = np.zeros(convoutput.shape)
imagePad[halfKr:-halfKr:1,halfKr:-halfKr:1] = image


for rowi in range(halfKr,imgN+halfKr):   # pętla po wierszach
  for coli in range(halfKr,imgN+halfKr): # pętla po kolumnach

    # pobieram wycinek obrazu
    pieceOfImg = imagePad[rowi-halfKr:rowi+halfKr+1:1,coli-halfKr:coli+halfKr+1:1]

    # iloczyn skalarny: iloczyn Hadamarda i sumowanie
    dotprod = np.sum( pieceOfImg*kernel )

    # zapamiętuję wynik dla tego piksela
    convoutput[rowi,coli] = dotprod


convoutput = convoutput[halfKr:-halfKr:1,halfKr:-halfKr:1]

convoutput2 = convolve2d(image,kernel,mode='same')

fig,ax = plt.subplots(2,2,figsize=(8,8))

ax[0,0].imshow(image)
ax[0,0].set_title('Obrazek')

ax[0,1].imshow(kernel)
ax[0,1].set_title('Jądro')

ax[1,0].imshow(convoutput)
ax[1,0].set_title('Ręczne obliczanie konwolucji')

ax[1,1].imshow(convoutput2)
ax[1,1].set_title("Konwolucja w SciPy")

# for i in ax.flatten(): i.axis('off')

plt.savefig('rys7.4b.png',dpi=300)
plt.show()



bathtub = io.imread('https://upload.wikimedia.org/wikipedia/commons/6/61/De_nieuwe_vleugel_van_het_Stedelijk_Museum_Amsterdam.jpg')

print(bathtub.shape)

fig = plt.figure(figsize=(10,6))
plt.imshow(bathtub)
plt.savefig('rys7.5a.png',dpi=300)
plt.show()

bathtub2d = color.rgb2gray(bathtub)

print(bathtub2d.shape)

kernelN = 29
Y,X     = np.meshgrid(np.linspace(-3,3,kernelN),np.linspace(-3,3,kernelN))
kernel  = np.exp( -(X**2+Y**2)/20 )
kernel  = kernel / np.sum(kernel) # normalizacja

smooth_bathtub = convolve2d(bathtub2d,kernel,mode='same')

fig = plt.figure(figsize=(10,6))
plt.imshow(smooth_bathtub,cmap='gray')
plt.savefig('rys7.5b.png',dpi=300)
plt.show()



"""# Ćwiczenie 1."""

# macierz diagonalna zawierająca odwrotności odchyleń standardowych
variances = np.diag(covMat) # wariancje znajdują się na przekątnej macierzy kowariancji
standard_devs = np.sqrt( variances )
S = np.diag( 1/standard_devs )

# da się to też zrobić w jednej linii:
#S = np.diag( 1/np.sqrt(np.diag(covMat)) )


# obliczam macierz korelacji
corrMat = S @ covMat @ S


# i ją wyświetlam
fig,axs = plt.subplots(1,2,figsize=(13,6))
h1 = axs[0].imshow(covMat,vmin=-clim,vmax=clim,cmap='gray')
axs[0].set_title('Macierz kowariancji danych',fontweight='bold')

h2 = axs[1].imshow(corrMat,vmin=-.5,vmax=.5,cmap='gray')
axs[1].set_title('Macierz korelacji danych',fontweight='bold')

fig.colorbar(h1,ax=axs[0],fraction=.045)
fig.colorbar(h2,ax=axs[1],fraction=.045)

plt.tight_layout()
plt.savefig('rys7.6.png',dpi=300)
plt.show()

# fragment kodu pozwalający sprawdzić konkretne wartośi

i,j = 43,17

corrMat[i,j], data.columns[i], data.columns[j]



"""# Ćwiczenie 2."""

# funkcja obliczająca korelację z NumPy (uwaga na transpozycję!)
corrMat_np = np.corrcoef(dataMat.T)


# wykreślanie wyników
fig,axs = plt.subplots(1,3,figsize=(13,6))
h1 = axs[0].imshow(corrMat,vmin=-.5,vmax=.5,cmap='gray')
axs[0].set_title('Moja macierz korelacji',fontweight='bold')

h2 = axs[1].imshow(corrMat_np,vmin=-.5,vmax=.5,cmap='gray')
axs[1].set_title("Macierz korelacji z NumPy",fontweight='bold')

h3 = axs[2].imshow(corrMat_np-corrMat,vmin=-.0005,vmax=.0005,cmap='gray')
axs[2].set_title('Macierz różnic',fontweight='bold')

fig.colorbar(h1,ax=axs[0],fraction=.045)
fig.colorbar(h2,ax=axs[1],fraction=.045)
fig.colorbar(h3,ax=axs[2],fraction=.045)

plt.tight_layout()
plt.savefig('rys7.7.png',dpi=300)
plt.show()

??np.corrcoef

??np.cov



"""# Ćwiczenie 3."""

T = np.array([
              [1,.5],
              [0,.5]
            ])


# definiuję zbiór punktów (z okręgu)
theta = np.linspace(0,2*np.pi-2*np.pi/20,20)
origPoints = np.vstack( (np.cos(theta),np.sin(theta)) )

# stosuję przekształcenie
transformedPoints = T @ origPoints


# wkreślam wynik
plt.figure(figsize=(6,6))
plt.plot(origPoints[0,:],origPoints[1,:],'ko',label='Przed przekształceniem')
plt.plot(transformedPoints[0,:],transformedPoints[1,:],'s',
         color=[.7,.7,.7],label='Po przekształceniu')

plt.axis('square')
plt.xlim([-2,2])
plt.ylim([-2,2])
plt.legend()
plt.savefig('rys7.8.png',dpi=300)
plt.show()



"""# Ćwiczenie 4."""

# funkcja tworząca rysunek
def aframe(ph):

  # tworzę macierz transformacji
  T = np.array([ [  1-ph/3,0 ],
                 [  0,ph   ] ])

  # stosuję przekształcenie za pomocą mnożenia macierzy
  P1 = T@Y1
  P2 = T@Y2

  # aktualizuję górną/dolną krzywą
  plth1.set_xdata(P1[0,:])
  plth1.set_ydata(P1[1,:])

  plth2.set_xdata(P2[0,:])
  plth2.set_ydata(P2[1,:])

  # zwracam uchwyty do rysunku
  return (plth1,plth2)

# definiuję punktu XY
th = np.linspace(0,2*np.pi,100) # th - kąt
Y1 = np.vstack((th,np.cos(th)))
Y2 = np.vstack((th,np.sin(th)))


# przygotowuję rysunek
fig,ax = plt.subplots(1,figsize=(12,6))

plth1, = ax.plot(Y1[0,:],Y1[1,:],'ko')
plth2, = ax.plot(Y2[0,:],Y2[1,:],'s',color=[.7,.7,.7])
ax.set_ylim([-2,2])


# definiuję fazę i uruchamiam animację
phi = 1-np.linspace(-1,1-1/40,40)**2
animation.FuncAnimation(fig, aframe, phi, interval=50, repeat=True)



"""# Ćwiczenie 5."""

# inicjalizacja zmiennej do przechowywania wyniku
smooth_bathtub = np.zeros(bathtub.shape)

# wygładzam osobno każdą z warstw
for i in range(smooth_bathtub.shape[2]):
  smooth_bathtub[:,:,i] = convolve2d(bathtub[:,:,i],kernel,mode='same')


fig = plt.figure(figsize=(10,6))
plt.imshow(smooth_bathtub.astype(np.uint8))
plt.show()

# sprawdzam typy danych
print( smooth_bathtub.dtype )
print( smooth_bathtub.astype(np.uint8).dtype )

"""# Ćwiczenie 6."""

# różne szerokości dla różnych warstw
kernelN = 31
kernelWidths = [.5,5,50]


# inicjalizacja zmiennej do przechowywania wyniku
smooth_bathtub = np.zeros(bathtub.shape)

# wyświetlam jądra
_,axs = plt.subplots(1,3,figsize=(12,6))

# wygładzam osobno każdą z warstw
for i in range(smooth_bathtub.shape[2]):

  # tworzę jądro
  Y,X     = np.meshgrid(np.linspace(-3,3,kernelN),np.linspace(-3,3,kernelN))
  kernel  = np.exp( -(X**2+Y**2) / kernelWidths[i] )
  kernel  = kernel / np.sum(kernel) # normalizuję

  # wizualizuję jądra
  axs[i].imshow(kernel,cmap='gray')
  axs[i].set_title(f'Szerokość: {kernelWidths[i]} (kanał: {"RGB"[i]})')

  # przeprowadzam konwolucję
  smooth_bathtub[:,:,i] = convolve2d(bathtub[:,:,i],kernel,mode='same')

plt.savefig('rys7.10.png',dpi=300)
plt.show()


# wyświetlam wynik
fig = plt.figure(figsize=(10,6))
plt.imshow(smooth_bathtub.astype(np.uint8))
plt.show()



"""# Ćwiczenie 7."""

# tworzę dwa jądra do wykrywania cech

# jądro wertykalne
VK = np.array([ [1,0,-1],
                [1,0,-1],
                [1,0,-1] ])

# jądro horyzontalne
HK = np.array([ [ 1, 1, 1],
                [ 0, 0, 0],
                [-1,-1,-1] ])

fig,ax = plt.subplots(2,2,figsize=(16,8))

ax[0,0].imshow(VK,cmap='gray')
ax[0,0].set_title('Jądro wertykalne')
ax[0,0].set_yticks(range(3))

ax[0,1].imshow(HK,cmap='gray')
ax[0,1].set_title('Jądro horyzontalne')
ax[0,1].set_yticks(range(3))

# przeprowadzam konwolucję i wyświetlam jej wyniki
convres = convolve2d(bathtub2d,VK,mode='same')
ax[1,0].imshow(convres,cmap='gray',vmin=0,vmax=.01)
ax[1,0].axis('off')

convres = convolve2d(bathtub2d,HK,mode='same')
ax[1,1].imshow(convres,cmap='gray',vmin=0,vmax=.01)
ax[1,1].axis('off')

plt.savefig('rys7.11.png',dpi=300)
plt.show()

